/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher.xml;

import com.oxaion.tools.weblauncher.data.Configuration;
import com.oxaion.tools.weblauncher.data.OSConfiguration;
import com.oxaion.tools.weblauncher.data.RunCommand;
import com.oxaion.tools.weblauncher.data.TimeoutCommand;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationParser
extends DefaultHandler {
    private Configuration config;
    private StringBuffer currentBuffer = new StringBuffer();
    private OSConfiguration currentOS;
    private RunCommand currentCommand;

    public void parse(InputSource input, Configuration baseConfig, String[] additionalArguments) throws ParserConfigurationException, SAXException, IOException {
        this.config = baseConfig;
        this.config.getOSConfigurations().clear();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(input, (DefaultHandler)this);
        for (OSConfiguration o : baseConfig.getOSConfigurations()) {
            if (o.getCommands().size() <= 0) continue;
            o.getCommands().get(o.getCommands().size() - 1).addParameters(additionalArguments);
        }
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        this.currentBuffer = new StringBuffer();
        if (qName.equals("os")) {
            this.currentOS = this.config.getOSConfiguration(attrs.getValue("name"), true);
        } else if (qName.equals("run")) {
            this.currentCommand = new RunCommand();
            this.currentOS.addCommand(this.currentCommand);
        } else if (qName.equals("timeout")) {
            this.currentCommand = new TimeoutCommand(Integer.parseInt(attrs.getValue("length")));
            this.currentOS.addCommand(this.currentCommand);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("versionfile")) {
            this.config.setVersionFile(this.currentBuffer.toString());
        } else if (qName.equals("language")) {
            this.config.setLanguage(this.currentBuffer.toString());
        } else if (qName.equals("workingdir")) {
            this.currentCommand.setWorkingDir(this.replaceParameters(this.currentBuffer.toString()));
        } else if (qName.equals("parameter")) {
            this.currentCommand.addParameters(this.replaceParameters(this.currentBuffer.toString()));
        } else if (qName.equals("command")) {
            this.currentCommand.setCommand(this.replaceParameters(this.currentBuffer.toString()));
        } else if (qName.equals("installationpath")) {
            this.currentOS.setInstallationPath(this.replaceParameters(this.currentBuffer.toString()));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.currentBuffer.append(buf, offset, len);
    }

    public String replaceParameters(String source) {
        int index = 0;
        while (source.indexOf("%", index) >= 0) {
            int indexStart = source.indexOf("%", index);
            int indexEnd = source.indexOf("%", indexStart + 1);
            if (indexEnd > indexStart) {
                String env = source.substring(indexStart + 1, indexEnd);
                String envValue = null;
                if (!"HOST".equals(env.toUpperCase())) {
                    envValue = System.getenv(env);
                }
                if (envValue != null) {
                    envValue = envValue.replace("\\", "/");
                    source = source.replace("%" + env + "%", envValue);
                }
                index = indexEnd;
            }
            ++index;
        }
        String programFiles = System.getenv("ProgramFiles");
        if (programFiles != null) {
            source = source.replaceAll("%PROGRAMS%", programFiles.replaceAll("\\\\", "/"));
        }
        return source.replaceAll("%HOST%", this.config.getHostIdentifier());
    }
}

